unit EditEmployeeForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, BaseDataset, NozicleComponents, StdCtrls, ExtCtrls, ComCtrls, Mask,
  DBCtrls;

type
  TfmEditEmployee = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    DataSource: TDataSource;
    NozicleDataset: TNozicleDataset;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    DateTimePicker: TDateTimePicker;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    Panel3: TPanel;
    Label6: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function EditEmployee( employeeID: string ): BOOLEAN;

implementation

{$R *.DFM}

uses
  Main;

function EditEmployee( employeeID: string ): BOOLEAN;
var
  fmEditEmployee: TfmEditEmployee;
begin
  result := FALSE;
  fmEditEmployee := TfmEditEmployee.Create(nil);
  try
    if employeeID = '' then
      fmEditEmployee.NozicleDataset.SQL := 'select * from employee limit 0'
    else
      fmEditEmployee.NozicleDataset.SQL := 'select * from employee where empno = "'+employeeID+'"';

    fmEditEmployee.NozicleDataset.Active := TRUE;
    fmMain.Caption := 'Employee';
    if fmEditEmployee.NozicleDataset.ErrorMessage <> '' then begin
      ShowMessage(fmEditEmployee.NozicleDataset.ErrorMessage);
      exit;
    end;

    if employeeID = '' then begin
      fmEditEmployee.NozicleDataset.Append;
      fmEditEmployee.NozicleDataset.FieldByName('hiredate').AsDateTime := Trunc(now);
      fmEditEmployee.NozicleDataset.Post;  // create the guid
      fmEditEmployee.NozicleDataset.Edit;
      fmEditEmployee.Caption := 'New Employee';
    end
    else begin
      fmEditEmployee.NozicleDataset.Edit;
      fmEditEmployee.Caption := 'Edit Employee: '+fmEditEmployee.NozicleDataset.FieldByName('firstname').AsString + ' ' +
                                fmEditEmployee.NozicleDataset.FieldByName('lastname').AsString;
    end;

    fmEditEmployee.DateTimePicker.Date := fmEditEmployee.NozicleDataset.FieldByName('hiredate').AsDateTime;

    if fmEditEmployee.ShowModal = mrOK then begin
      fmEditEmployee.NozicleDataset.FieldByName('hiredate').AsDateTime := fmEditEmployee.DateTimePicker.Date;
      fmEditEmployee.NozicleDataset.Post;
      fmEditEmployee.NozicleDataset.PostToWeb; // NOTE: This will not work if using the demo database hosted
                                               // at www.nozicle.com/demodb as only have read-only access.
                                               // You will need to install your own database on your own
                                               // webserver.
      result := TRUE;
    end;
  finally
    fmEditEmployee.Free;
  end;
end;

end.
